@extends('layouts.admin')

@section('title', 'Server Details')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>Server: {{ $server->name }}</h1>
            <div>
                <a href="{{ route('admin.servers.edit', $server->id) }}" class="btn btn-primary mr-sm">
                    <i class="fas fa-edit"></i> Edit Server
                </a>
                <a href="{{ route('admin.servers.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Servers
                </a>
            </div>
        </div>
        <p>View server details and status</p>
</div>

    <div class="row">
        <div class="col-md-6">
            <div class="dashboard-card mb-4">
                <div class="dashboard-card-header">
                    <h3>Server Information</h3>
                </div>
                <div class="dashboard-card-body">
                    <table class="table table-details">
                        <tbody>
                            <tr>
                                <th>Name</th>
                                <td>{{ $server->name }}</td>
                            </tr>
                            <tr>
                                <th>Address</th>
                                <td>{{ $server->ip }}:{{ $server->port }}</td>
                            </tr>
                            <tr>
                                <th>App ID</th>
                                <td>{{ $server->app_id }}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($server->is_active)
                                    <span class="server-status-badge online">
                                        <i class="fas fa-circle"></i> Active
                                    </span>
                                    @else
                                    <span class="server-status-badge offline">
                                        <i class="fas fa-circle"></i> Inactive
                                    </span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Created</th>
                                <td>{{ $server->created_at->format('M d, Y H:i') }}</td>
                            </tr>
                            <tr>
                                <th>Last Updated</th>
                                <td>{{ $server->updated_at->format('M d, Y H:i') }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>API Key</h3>
                </div>
                <div class="dashboard-card-body">
                    @if(session('apiKey'))
                    <div class="alert alert-success">
                        <strong>New API Key:</strong> 
                        <code>{{ session('apiKey') }}</code>
                        <div class="mt-2">
                            <small class="text-warning">This key will be shown only once!</small>
                        </div>
                    </div>
                    @endif

                    <p>The API key is used for secure communication between the game server and your website.</p>
                    <div class="form-group">
                        <div class="d-flex align-items-center">
                            <input type="password" value="••••••••••••••••••••••••••••••••" class="form-control" readonly id="apiKeyField">
                            <button type="button" class="btn btn-secondary ml-sm" onclick="toggleApiKey()" id="toggleBtn">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>
                    
                    <form action="{{ route('admin.servers.reset-api-key', $server->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to reset this API key? The old key will no longer work.');">
                        @csrf
                        <button type="submit" class="btn btn-warning">
                            <i class="fas fa-key"></i> Reset API Key
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="dashboard-card">
                <div class="dashboard-card-header d-flex justify-content-between align-items-center">
                    <h3>Live Server Status</h3>
                    <form action="{{ route('admin.servers.refresh-info', $server->id) }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-sync-alt"></i> Refresh
                        </button>
                    </form>
                </div>
                <div class="dashboard-card-body">
                    @if(isset($serverInfo) || session('serverInfo'))
                        @php
                            $info = session('serverInfo') ?? $serverInfo;
                        @endphp
                        
                        <div class="server-info-header">
                            <div class="server-info-item">
                                <span class="server-label">Game:</span>
                                <span class="server-value">{{ $info['product'] ?? 'Unknown' }}</span>
                            </div>
                            <div class="server-info-item">
                                <span class="server-label">Status:</span>
                                <span class="server-status-badge online">
                                    <i class="fas fa-circle"></i> Online
                                </span>
                            </div>
                        </div>

                        <div class="resource-meter">
                            <div class="resource-label">
                                <span>Players</span>
                                <span>{{ $info['players'] ?? 0 }}/{{ $info['max_players'] ?? 0 }}</span>
                            </div>
                            <div class="progress">
                                @php
                                    $playerPercent = 0;
                                    if (isset($info['players']) && isset($info['max_players']) && $info['max_players'] > 0) {
                                        $playerPercent = ($info['players'] / $info['max_players']) * 100;
                                    }
                                @endphp
                                <div class="progress-bar" style="width: {{ $playerPercent }}%"></div>
                            </div>
                        </div>

                        <table class="table table-details mt-4">
                            <tbody>
                                <tr>
                                    <th>Current Map</th>
                                    <td>{{ $info['map'] ?? 'Unknown' }}</td>
                                </tr>
                                <tr>
                                    <th>Server Name</th>
                                    <td>{{ $info['name'] ?? 'Unknown' }}</td>
                                </tr>
                                <tr>
                                    <th>Secure</th>
                                    <td>{{ isset($info['secure']) && $info['secure'] ? 'Yes' : 'No' }}</td>
                                </tr>
                                <tr>
                                    <th>VAC Enabled</th>
                                    <td>{{ isset($info['vac_enabled']) && $info['vac_enabled'] ? 'Yes' : 'No' }}</td>
                                </tr>
                                <tr>
                                    <th>Game Version</th>
                                    <td>{{ $info['version'] ?? 'Unknown' }}</td>
                                </tr>
                                <tr>
                                    <th>Server Tags</th>
                                    <td>{{ $info['tags'] ?? 'None' }}</td>
                                </tr>
                                <tr>
                                    <th>Password Protected</th>
                                    <td>{{ isset($info['password_protected']) && $info['password_protected'] ? 'Yes' : 'No' }}</td>
                                </tr>
                                <tr>
                                    <th>Last Update</th>
                                    <td>
                                        @if(isset($info['last_updated']))
                                            {{ \Carbon\Carbon::createFromTimestamp($info['last_updated'])->diffForHumans() }}
                                        @else
                                            Unknown
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <div class="text-center p-4">
                            <i class="fas fa-server fa-3x text-secondary mb-3"></i>
                            <p>No server information available. The server may be offline or not properly configured.</p>
                            <p>Make sure the server is running and the Steam API key is configured correctly.</p>
                            <form action="{{ route('admin.servers.refresh-info', $server->id) }}" method="POST">
                                @csrf
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-sync-alt"></i> Try Again
                                </button>
                            </form>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
    function toggleApiKey() {
        const apiKeyField = document.getElementById('apiKeyField');
        const toggleBtn = document.getElementById('toggleBtn');
        
        if (apiKeyField.type === 'password') {
            apiKeyField.type = 'text';
            apiKeyField.value = '{{ $server->api_key }}';
            toggleBtn.innerHTML = '<i class="fas fa-eye-slash"></i>';
        } else {
            apiKeyField.type = 'password';
            apiKeyField.value = '••••••••••••••••••••••••••••••••';
            toggleBtn.innerHTML = '<i class="fas fa-eye"></i>';
        }
    }
</script>
@endpush